define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service("connectionTimeoutService", function ($http, $timeout, $state, $modal, unsavedWarningSharedService, authenticationService) {
		var service = {};

		var timeToExpire,
			timeUnitsText = "minutes",
			timeUnitText = "minute",
			displayTimeUnits = 60000, // one minute
			warningThreshold = 3 * displayTimeUnits,
			sessionEnded = false,
			conversionFactor = 1000,
			timeoutPromise,
			modalInstance,
			modalInfo = {value: null, dismissed: true};

		var timeoutDialogController = function () {
			var waitTime,
				expiryTime = isNaN(authenticationService.getParsedToken().exp) ? new Date(0) : (authenticationService.getParsedToken().exp * conversionFactor);

			timeToExpire = expiryTime - Date.now();
			console.debug('time to expire', new Date(timeToExpire * 1000));
			if (timeToExpire <= warningThreshold) {
				showTimeoutWarning(timeToExpire);
				waitTime = displayTimeUnits;
			} else {
				dismissModal();
				waitTime = timeToExpire - warningThreshold;
			}

			if (!sessionEnded) {
				$timeout.cancel(timeoutPromise);
				timeoutPromise = $timeout(function () {
					timeoutDialogController();
				}, waitTime, false);
			}
		};

		var dismissModal = function () {
			if (angular.isDefined(modalInstance) && !modalInfo.dismissed) {
				modalInfo.dismissed = true;
				modalInstance.dismiss();
			}
		};

		var openModal = function (template, controller, modalInfo) {
			dismissModal();

			modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: template,
				controller: controller,
				backdrop: 'static',
				keyboard: false,
				resolve: {
					modalInfo: function () {
						return modalInfo;
					}
				}
			});
		};

		var showTimeoutWarning = function (timeToExpire) {
			var minutesToExpire = Math.round(parseInt(timeToExpire, 10) / displayTimeUnits);

			if (minutesToExpire <= 0) {
				sessionEnded = true;
				authenticationService.gotoLogoutWithRedirect();
				angular.element("div.container-fluid").remove();
			}
			else {
				modalInfo.value = minutesToExpire;
				modalInfo.unit = modalInfo.value !== 1 ? timeUnitsText : timeUnitText;
				openModal('src/core/connection/timeout_warning_template.html', ModalInstanceCtrl, modalInfo);
			}
		};

		service.run = function () {
			timeoutDialogController();
		};

		service.showSessionEndedMsg = function () {
			sessionEnded = true;

			unsavedWarningSharedService.cleanAllForms();

			angular.element("div.container-fluid").remove();
			openModal('src/core/connection/session_ended_template.html', ModalInstanceCtrl, modalInfo);
		};

		return service;
	});
});

function ModalInstanceCtrl($scope, $http, $timeout, $modalInstance, modalInfo, authenticationService, userService, focusService) {
	modalInfo.dismissed = false;

	$timeout(function () {
		focusService.focusTopModal();
	}, 600);

	$scope.logout = function () {
		$modalInstance.dismiss();
		authenticationService.gotoLogoutWithRedirect();
	};
	$scope.proceed = function () {
		$modalInstance.dismiss();
		userService.refreshJwt();
		modalInfo.dismissed = true;
		$modalInstance.result.finally(function(){
			focusService.focusMain();
		});
	};
	$scope.launchpad = function () {
		$modalInstance.dismiss();
		authenticationService.gotoLogoutWithRedirect();
	};
	$scope.login = function () {
		$modalInstance.dismiss();
		authenticationService.authorize();
	};

	$scope.modalInfo = modalInfo;
}